/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.Swapper;
import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;

public class GenericPermuting {
    protected GenericPermuting() {
    }

    public static int[] permutation(long l, int n) {
        int n2;
        if (l < 1L) {
            throw new IllegalArgumentException("Permutations are enumerated 1 .. N!");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Must satisfy N >= 0");
        }
        int[] nArray = new int[n];
        if (n > 20) {
            int n3 = n;
            while (--n3 >= 0) {
                nArray[n3] = n3;
            }
            DoubleUniform doubleUniform = new DoubleUniform(new DoubleMersenneTwister((int)l));
            for (int i = 0; i < n - 1; ++i) {
                int n4 = doubleUniform.nextIntFromTo(i, n - 1);
                int n5 = nArray[n4];
                nArray[n4] = nArray[i];
                nArray[i] = n5;
            }
            return nArray;
        }
        if (l > DoubleArithmetic.longFactorial(n)) {
            throw new IllegalArgumentException("N too large (a sequence of N elements only has N! permutations).");
        }
        int[] nArray2 = new int[n];
        for (int i = 1; i <= n; ++i) {
            nArray2[i - 1] = i;
        }
        long l2 = l - 1L;
        for (n2 = n - 1; n2 >= 1; --n2) {
            long l3 = DoubleArithmetic.longFactorial(n2);
            int n6 = (int)(l2 / l3) + 1;
            l2 %= l3;
            nArray[n - n2 - 1] = nArray2[n6 - 1];
            for (int i = n6; i <= n2; ++i) {
                nArray2[i - 1] = nArray2[i];
            }
        }
        if (n > 0) {
            nArray[n - 1] = nArray2[0];
        }
        n2 = n;
        while (--n2 >= 0) {
            nArray[n2] = nArray[n2] - 1;
        }
        return nArray;
    }

    public static void permute(int[] nArray, int[] nArray2) {
        int[] nArray3 = (int[])nArray.clone();
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = nArray3[nArray2[n]];
        }
    }

    @Deprecated
    public static void permute(int[] nArray, Swapper swapper, int[] nArray2) {
        GenericPermuting.permute(nArray, swapper, nArray2, null);
    }

    public static void permute(int[] nArray, Swapper swapper, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        int[] nArray4 = nArray2;
        int[] nArray5 = nArray3;
        if (nArray4 == null || nArray4.length < n) {
            nArray4 = new int[n];
        }
        if (nArray5 == null || nArray5.length < n) {
            nArray5 = new int[n];
        }
        int n2 = n;
        while (--n2 >= 0) {
            nArray4[n2] = n2;
            nArray5[n2] = n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = nArray[n2];
            int n4 = nArray4[n3];
            if (n2 == n4) continue;
            swapper.swap(n2, n4);
            nArray4[n3] = n2;
            nArray4[nArray5[n2]] = n4;
            int n5 = nArray5[n2];
            nArray5[n2] = nArray5[n4];
            nArray5[n4] = n5;
        }
    }

    public static void permute(Object[] objectArray, int[] nArray) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        int n = objectArray.length;
        while (--n >= 0) {
            objectArray[n] = objectArray2[nArray[n]];
        }
    }
}

