#'Determine the pair by pair effects that are important for the analysis.
#'@description Selects, pair by pair, the effect of S.S. on L.S.
#'@usage SelectEffectivenessOfSolution(EffectivenessOfSolution)
#'@param EffectivenessOfSolution Output generated by the function  `EffectivenessOfSolution`

#'@author Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
#' Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)
#'@return Returns a vector with logical values demonstrating the
#'interactions considered important for the analysis.
#'@seealso  \code{\link{EffectivenessOfSolution}} ,  \code{\link{NonAttentionLevel}}  ,  \code{\link{LossSource}}
#'@importFrom stats lm
#'@export
#'@examples
#\dontrun{
#'library(ImportanceIndice)
#'data("DataLossSource")
#'data("DataSolutionSource")
#'data("DataProduction")
#'data("DataNumberSamples")
#'
#'Distribution_LossSource(DataLossSource)
#'Distribution_SolutionSource(DataSolutionSource)
#'
#'#################################################
#'###################################################
#'
#'
#'
#'LS=LossSource(DataLoss = DataLossSource,DataProd = DataProduction,verbose = TRUE)
#'LS
#'
#'LP=LossProduction(Data=DataLossSource,Prod = DataProduction,
#'                  Evaluation=DataNumberSamples,
#'                  SegurityMargen=0.75,MaximumToleranceOfLossFruits=1)
#'LP
#'
#'
#'ES=EffectivenessOfSolution(DataLossSource=DataLossSource,
#'                           DataSolutionSource=DataSolutionSource,Production =DataProduction)
#'ES
#'
#'
#'
#'
#'id=SelectEffectivenessOfSolution(ES)
#'id=c(TRUE , TRUE,  TRUE , FALSE,  TRUE)
#'
#'
#'SS=SolutionSource(SolutionData = DataSolutionSource,
#'                  EffectivenessOfSolution = ES,Production = DataProduction,Id = id)
#'SS
#'
#'
#'NAL=NonAttentionLevel(EffectivenessOfSolution = ES,LossProduction = LP,Id = id,Verbose=TRUE)
#'NAL
#}



SelectEffectivenessOfSolution=function(EffectivenessOfSolution){
  Es=EffectivenessOfSolution
  ID=NULL
  for(i in 1:nrow(Es)){
    res=as.matrix(Es[i,])

    print(paste0(res[1]," VS ",res[2], ": ES=",res[3]))
    bk=readline(prompt = "Deseja considerar essa combinacao (y/n)? ")
    ID=c(ID,bk)
  }

  ID=ID=="y"

  ID
}
