% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Immigrate.R
\name{Immigrate}
\alias{Immigrate}
\title{Immigrate}
\usage{
Immigrate(
  xx,
  yy,
  w0,
  epsilon = 0.01,
  sig = 1,
  max_iter = 10,
  removesmall = FALSE,
  randomw0 = FALSE
)
}
\arguments{
\item{xx}{model matrix of explanatory variables}

\item{yy}{label vector}

\item{w0}{initial weights}

\item{epsilon}{criterion for stopping iteration}

\item{sig}{sigma used in algorithm, default to be 1}

\item{max_iter}{maximum number of iteration}

\item{removesmall}{whether to remove features with small weights, default to be FALSE}

\item{randomw0}{whether to use randomly initial weights, default to be FALSE}
}
\value{
\item{w}{new weight after one loop}

\item{iter_num}{ number of iteration for convergence}

\item{final_c}{final cost}
}
\description{
This function performs Immigrate(Iterative Max-Min Entropy Margin-Maximization with Interaction Terms ) algorithm.
}
\examples{
data(park)
xx<-park$xx
yy<-park$yy
re<-Immigrate(xx,yy)
print(re)
}
\references{
Zhao R, Hong P, Liu J S. IMMIGRATE: A Margin-based Feature Selection Method with Interaction Terms[J]. arXiv preprint arXiv:1810.02658, 2018.
}
\seealso{
\url{https://arxiv.org/abs/1810.02658} for more details.
}
\keyword{Immigrate}
