% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one.imIM4E.R
\name{one.imIM4E}
\alias{one.imIM4E}
\title{one.imIM4E}
\usage{
one.imIM4E(train_xx, train_yy, w, sig = 1, rho = 1, lambda = 1)
}
\arguments{
\item{train_xx}{model matrix of explanatory variables}

\item{train_yy}{label vector}

\item{w}{initial weight}

\item{sig}{sigma used in algorithm, default to be 1}

\item{rho}{rho used in algorithm, default to be 1}

\item{lambda}{lambda used in algorithm, default to be 1}
}
\value{
\item{w}{new weight after one loop}

\item{C}{ cost after one loop}
}
\description{
This function performs imIM4E(imbalance Iterative Margin-Maximization under Max-Min entropy) algorithm for one loop.
}
\examples{
data(park)
xx<-park$xx
yy<-park$yy
w0 <- rep(1,ncol(xx))/ncol(xx)
re<-one.imIM4E(xx,yy,w0)
print(re$w)
}
\keyword{imIM4E}
