library(survival)
attach(melanom)
names(melanom)
Surv(days, status==1)
survfit(Surv(days,status==1)~1) # ~1 required from R 2.9.0
surv.all <- survfit(Surv(days,status==1)~1)
summary(surv.all)
plot(surv.all)
if (.make.epsf) dev.copy2eps(file="surv-all.ps")
surv.bysex <- survfit(Surv(days,status==1)~sex)
plot(surv.bysex)
if (.make.epsf) dev.copy2eps(file="surv-bysex.ps")
plot(surv.bysex, conf.int=T, col=c("black","gray"))
survdiff(Surv(days,status==1)~sex)
survdiff(Surv(days,status==1)~sex+strata(ulc))
summary(coxph(Surv(days,status==1)~sex))
summary(coxph(Surv(days,status==1)~sex+log(thick)+strata(ulc)))
plot(survfit(coxph(Surv(days,status==1)~
             log(thick)+sex+strata(ulc))))
if (.make.epsf) dev.copy2eps(file="surv-cox.ps")
rm(list=ls())
while(search()[2] != "package:ISwR") detach()
