% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.extra.geospatial.R
\name{ISRaD.extra.geospatial}
\alias{ISRaD.extra.geospatial}
\title{ISRaD.extra.geospatial}
\usage{
ISRaD.extra.geospatial(
  database,
  geodata_directory,
  CRS = "+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"
)
}
\arguments{
\item{database}{ISRaD dataset object}

\item{geodata_directory}{Directory where geospatial data are found}

\item{CRS}{Coordinate reference system used for geospatial datasets}
}
\value{
Updated ISRaD_extra object with new columns at the profile level
}
\description{
Extracts data from a user-supplied raster file and adds data as a new variable at the profile level
}
\details{
Generic function that uses geographic coordinates of profiles to extract data from one or more raster files.
Raster data will be added as new variables at the profile level.\cr\cr
The new variable name will be a concatenation of "pro_", and the file name (excluding the file extension).
The ISRaD file name convention for geospatial files uses a 6 component string, separated by "_". Missing components can be replaced with "x" ("x"s will be dropped before creating variable names). The 6 components are as follows:\cr\cr
1) Short description of the data type, e.g. "bd" for bulk density\cr
2) Top layer depth or exact depth (numeric, cm)\cr
3) Bottom layer depth (numeric, cm)\cr
4) Year of data observation (numeric)\cr
5) Data units (e.g. mmyr for mean annual precipitation)\cr
6) Any relevant notes\cr\cr
Coordinate reference system can be specified with the "CRS" argument; default is WGS84. Note that all files in geodata_directory must use the same CRS.\cr\cr
}
\examples{
\donttest{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
# Fill profile coordinates
database <- ISRaD.extra.fill_coords(database)
# Run function
# Note that geospatial data in pkg is only for the Gaudinski_2001 dataset
# Users may supply their own geospatial data as long as it can be read by the raster package
database.x <- ISRaD.extra.geospatial(database,
  geodata_directory = system.file("extdata", "geodata_directory", package = "ISRaD")
)
}

}
