% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.extra.Cstocks.R
\name{ISRaD.extra.Cstocks}
\alias{ISRaD.extra.Cstocks}
\title{ISRaD.extra.Cstocks}
\usage{
ISRaD.extra.Cstocks(database)
}
\arguments{
\item{database}{ISRaD dataset object.}
}
\value{
ISRaD_data object with filled columns "lyr_coarse_tot_filled", "lyr_bd_samp_filled", "lyr_c_inorg_filled", "lyr_c_org_filled", "lyr_soc_filled".
}
\description{
Calculates soil organic carbon stock
}
\details{
Function first fills lyr_bd_samp, lyr_c_org, lyr_c_org, lyr_coarse_tot. Notes:\cr\cr 1) SOC stocks can only be calculated if organic carbon concentration and bulk density data are available\cr\cr 2) SOC stocks are calculated for the fine earth fraction (<2mm).
}
\examples{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
database.x <- ISRaD.extra.Cstocks(database)
}
\author{
J. Beem-Miller
}
