% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.r, R/help.r
\docType{data}
\name{jupyter_option_defaults}
\alias{jupyter_option_defaults}
\alias{IRkernel-package}
\alias{IRkernel}
\alias{IRkernel-options}
\title{An R kernel for Jupyter.}
\format{
An object of class \code{list} of length 7.
}
\usage{
jupyter_option_defaults
}
\description{
Jupyter speaks a JSON+ZMQ protocol to a 'kernel' which is responsible for executing code.
This package is a kernel for the R language.
}
\section{Options}{


The following can be set/read via \code{options(opt.name = ...)} / \code{getOption('opt.name')}

\describe{
  \item{\code{jupyter.log_level}}{1L (errors), 2L (warnings), or 3L (debug). 1L is the default.}
  \item{\code{jupyter.pager_classes}}{Classes to use the pager for instead of displaying them inline. Default: help pages}
  \item{\code{jupyter.in_kernel}}{\code{TRUE} if this code is executed in a running kernel. Set to pretend being/not being in a kernel}
  \item{\code{jupyter.rich_display}}{Use more than just text display}
  \item{\code{jupyter.display_mimetypes}}{
     The formats emitted when any return value is to be displayed
     (default: all mimetypes listed \href{http://ipython.org/ipython-doc/stable/api/generated/IPython.core.formatters.html#IPython.core.formatters.format_display_data}{here}) 
  }
  \item{\code{jupyter.plot_mimetypes}}{
     The plot formats emitted to the frontend when a plot is displayed.
     (default: image/png and application/pdf)
  }
  \item{\code{jupyter.plot_scale}}{
     The ratio (notebook PPI / \code{repr.plot.res}).
     E.g.: With the defaults \code{repr.plot.res}=120 px/in (PPI) and \code{jupyter.plot_scale}=2, 
     a 1in\eqn{\times}1in image will be displayed as a 0.5in\eqn{\times}0.5in, 240 PPI image.
     (default: 2, fit for retina displays)
  }
}
}

\seealso{
\link{installspec}
}
\keyword{datasets}
