
The library requires that C99 integer types are available on the
target computer.  Specifically the int8_t, int16_t, int32_t, int64_t
and their unsigned counterpart types.

## Unix

A simple 'make' on most Unix-like systems should build the library.

The included Makefile should work for most Unix-like environments and
most make variants; it is know to work with GNU make.

The CC and CFLAGS environment variables can be set to control the build.

By default a statically linked version of the library is built: 'libmseed.a'.

With GCC, clang or compatible build tools it is possible to build a shared
library with 'make shared'.

## macOS

A static library can be compiled using the above Unix instructions,
just run 'make'.

Using GCC, clang or compatible build tools it is possible to build a dynamic
library with 'make dynamic'.

## Windows (Win32)

On a WIN32 platform the library can be compiled by using the
Nmake compatible Makefile.win (e.g. 'nmake -f Makefile.win') or Open
Watcom's Wmake with Makefile.wat (e.g. 'wmake -f Makefile.wat'). The
default target is a static library 'libmseed.lib'.  The library has
been tested with Open Watcom 1.8.  A libmseed.def file is included
for use building and linking a DLL.
