% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_test.R
\name{lambda_test}
\alias{lambda_test}
\title{lambda_test}
\usage{
lambda_test(f, nB)
}
\arguments{
\item{f}{An \code{iOLS_path} fitted model object that you want
to apply this test on.}

\item{nB}{The number of iteration that you want to be done
in the bootstrap process used in the function.}
}
\value{
a lambda_test object.
}
\description{
Printing and plotting of the lambda-test.
}
\examples{
data(DATASET)
y = DATASET$y
x = as.matrix(DATASET[,c("X1","X2")])
lm = lm(log(y+1) ~ x)
lm_coef = c(coef(lm))
X = cbind(rep(1, nrow(x)), x)
k = iOLS_path(y, X, b_init = lm_coef, deltainf = 10^-5,
deltasup = 10^4, nbre_delta = 20,
epsi = 10^-3, error_type = "HC0")

L = lambda_test(k, nB = 5)

}
