% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{Plot.RT.Histogram}
\alias{Plot.RT.Histogram}
\alias{Plot.RT.Histogram.DataSetList}
\title{Plot histograms of the runtimes of a DataSetList at a certain target function value}
\usage{
Plot.RT.Histogram(dsList, ftarget, plot_mode = "overlay",
  use.equal.bins = F)

\method{Plot.RT.Histogram}{DataSetList}(dsList, ftarget,
  plot_mode = "overlay", use.equal.bins = F)
}
\arguments{
\item{dsList}{A DataSetList (should consist of only one function and dimension).}

\item{ftarget}{The target function value.}

\item{plot_mode}{How to plot the different hisograms for each algorithm. Can be either
'overlay' to show all algorithms on one plot, or 'subplot' to have one plot per algorithm.}

\item{use.equal.bins}{Whether to determine one bin size for all plots or have individual bin sizes for each algorithm}
}
\value{
A plot of the histograms of the runtimes at a the
        target function value of the DataSetList
}
\description{
Plot histograms of the runtimes of a DataSetList at a certain target function value
}
\examples{
Plot.RT.Histogram(subset(dsl, funcId == 1), 14)
}
