% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upperPadding.R
\name{upperPadding}
\alias{upperPadding}
\title{Prepare a matrix or a list of matrices
for use in some cgeneric code.}
\usage{
upperPadding(M, relative = FALSE)
}
\arguments{
\item{M}{a matrix or a list of matrices}

\item{relative}{logical. If a list of matrices is supplied,
it indicates if it is to be returned a relative index
and the value for each matrix. See details.}
}
\value{
If a unique matrix is given, return the
upper triangle considering the 'T' representation
in the Matrix package. If a list of matrices is given,
return a list of two elements: 'graph' and 'xx'.
The 'graph' is the union of the graph from each matrix.
If relative=FALSE, 'xx' is a matrix with number of column equals
the the number of matrices imputed.
If relative=TRUE, it is a list of length equal the number
of matrices imputed. See details.
}
\description{
Define a graph of the union of the supplied matrices
and return the row ordered diagonal plus upper triangle
after padding with zeroes each one so that
all the returned matrices have the same pattern.
}
\details{
If relative=FALSE, each columns of 'xx' is the
elements of the corresponding matrix after being padded
to fill the pattern of the union graph.
If relative=TRUE, each element of 'xx' would be a list
with a relative index, 'r', for each non-zero elements of
each matrix is returned relative to the union graph,
the non-lower elements, 'x', of the corresponding matrix,
and a vector, 'o', with the number of non-zero elements
for each line of each resulting matrix.
}
\examples{
A <- sparseMatrix(
  i = c(1, 1, 2, 3, 3, 5),
  j = c(2, 5, 3, 4, 5, 5),
  x = -(0:5), symmetric = TRUE
)
A
upperPadding(A)
B <- Diagonal(nrow(A), -colSums(A))
list(a = A, a = B)
upperPadding(list(a = A, b = B))
upperPadding(list(a = A, b = B), relative = TRUE)
}
