% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring.R
\name{scoring}
\alias{scoring}
\title{Scoring of indicator performance}
\usage{
scoring(trend_tbl = NULL, mod_tbl, press_type = NULL,
  crit_scores = INDperform::crit_scores_tmpl, sign_level = 0.05)
}
\arguments{
\item{trend_tbl}{Output tibble from the \code{\link{model_trend}} function.}

\item{mod_tbl}{Output tibble from the IND~pressure modeling functions.}

\item{press_type}{Data frame or tibble with pressure names (named `press`) in
first column and corresponding pressure types in second column (named `press_type`).
Needed for the spie chart! (see for an example \code{\link{press_type_ex}})}

\item{crit_scores}{Internal tibble of (sub)criteria and respective scores
named \code{crit_scores_tmpl}; can be modified by saving this data frame as
new object and removing single (sub)criteria or assigning weights (default
is 1). The variable `condition` represents a list of single elements or
vectors with various elements to base the scoring on. This can be modified
but needs to follow the same syntax.}

\item{sign_level}{Significance level on which scoring is built; default is
0.05.}
}
\value{
The function returns a nested tibble with the following elements depending on the
criteria rated
\describe{
  \item{\code{ind}}{A vector of the indicator names.}
  \item{\code{C8} and/or \code{C11}}{A vector of IND-specific scores for criterion 8 (trend
         indication) and/or C11 (management application).}
 \item{\code{press_spec_sc}}{A list-column of IND-specific data frames
 containing pressure-specific scores for the sub-criteria 9.1-9.2, 10.1-10.4.}
}
The tibble can easily be unnested by using the \code{\link[tidyr]{unnest}} function.
That is, each element of the data frame in the list-column \code{press_spec_sc} becomes
its own row in the tibble.
}
\description{
Scoring of each indicator based on an internal criterion-scoring scheme
applied on the output of the trend and pressure model functions.
}
\details{
Among the 16 common indicator selection criteria summarized in Otto \emph{et al.} (2018)
five criteria relate to the indicators` performances and require time series for
their evaluation, i.e.
\itemize{
  \item Crit. 8: Development reflects ecosystem change caused by variation in manageable pressure(s)
  \item Crit. 9: Sensitive or responsive to pressures
  \item Crit. 10: Robust, i.e. responses in a predictive fashion, and statistically sound
  \item Crit. 11: Links to management measures (responsiveness and specificity)
  \item Crit. 12: Relates where appropriate to other indicators but is not redundant (not scored)
}


In this function, the scoring scheme for these criteria as proposed by
Otto \emph{et al.} (2018) serves as basis for the quantification of the IND performance.
Sensitivity (criterion 9) and robustness (criterion 10) are specified into more detailed
sub-criteria to allow for quantification based on statistical models and rated individually
for every potential pressure that might affect the IND directly or indirectly. In the case
of non-significant relationships between a IND and a specific pressures, sub-crit. 9.1 and
all following pressure-specific sub-crit. in criteria 9 and 10 are scored zero for this
pressure.

The template tibble \code{crit_scores_tmpl} contains all relevant informations and
serves as basis for the scoring in this function. See for more details
\code{\link{crit_scores_tmpl}} or \code{View(crit_scores_tmpl)}. The scoring scheme can
easily be adapted to any kind of state indicator and management scheme by modifying
the scores, the weighting of scores or by removing or adding (sub)criteria in the
\code{crit_scores_tmpl} template. The \code{condition} variable can also be modified
but needs to follow the same syntax.
}
\examples{
# Using the Baltic Sea demo data in this package
scores_tbl <- scoring(trend_tbl = model_trend_ex, mod_tbl = all_results_ex,
  press_type = press_type_ex)
\donttest{
 # To see the criterion template and change it potentially
 View(crit_scores_tmpl)
 # E.g. exclude the trend criterion
 crit_scores_tmpl_new <- crit_scores_tmpl[crit_scores_tmpl$crit_id > 1, ]
 # Now the trend tibble is not needed anymore
 scores_tbl <- scoring(mod_tbl = all_results_ex, press_type = press_type_ex,
  crit_scores = crit_scores_tmpl_new)
}
}
\references{
Otto, S.A., Kadin, M., Casini, M., Torres, M.A., Blenckner, T. (2018)
A quantitative framework for selecting and validating food web indicators.
\emph{Ecological Indicators}, 84: 619-631,
doi: https://doi.org/10.1016/j.ecolind.2017.05.045
}
\seealso{
\code{\link[tidyr]{unnest}} to make each element of the data frame in the
list-column \code{press_spec_sc} its own row and \code{\link[tidyr]{nest}} for the
inverse operation

Other score-based IND performance functions: \code{\link{clust_sc}},
  \code{\link{dist_sc_group}}, \code{\link{dist_sc}},
  \code{\link{expect_resp}}, \code{\link{plot_clust_sc}},
  \code{\link{plot_spiechart}}, \code{\link{summary_sc}}

Other IND~pressure modeling functions: \code{\link{find_id}},
  \code{\link{ind_init}}, \code{\link{model_gamm}},
  \code{\link{model_gam}}, \code{\link{plot_diagnostics}},
  \code{\link{plot_model}}, \code{\link{select_model}},
  \code{\link{test_interaction}}
}
\concept{IND~pressure modeling functions}
\concept{score-based IND performance functions}
