% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_count.R
\name{motif_count}
\alias{motif_count}
\title{Calculating the number of 44 motifs}
\usage{
motif_count(network.or.subnet_mat1, subnet_mat2 = NULL, subnet_motif = FALSE)
}
\arguments{
\item{network.or.subnet_mat1}{Either a multilayer(tripartite) network of 'igraph' class, or a numeric matrix(or data.frame) representing interactions between two groups of species. The network contains
interlayer links and without intralayer links. Each row and column of matrix represents the species in the first and second layers of the tripartite network respectively.
Elements of matrix are non-zero numebers if the interlayer species are connected, and 0 otherwise.}

\item{subnet_mat2}{A numeric matrix(or data.frame) representing interactions between two groups of species.Each row and column of matrix represents the species in the second and third layers of the
tripartite network respectively. Elements of matrix are non-zero numebers if the interlayer species are connected, and 0 otherwise. If \code{network.or.subnet_mat1} is "igraph", \code{subnet_mat2} defaults to NULL.}

\item{subnet_motif}{Logical. Whether to calculate the structure indices of the two bipartite networks dismantled by this multilayer network based on the principle of the package bmotif. Default to FALSE: NO.}
}
\value{
If \code{subnet_motif} = FALSE, return a numeric vector with the number of 44 motifs: M111, M112, M113, M211, M212, M213, M311, M312, M121_1, M122_1, M122_2, M122_3, M123_1, M123_2, M123_3, M123_4, M123_5, M221_1, M221_2, M221_3, M222_1, M222_2, M222_3, M222_4, M222_5, M222_6, M222_7, M222_8, M321_1, M321_2, M321_3, M321_4, M321_5, M131, M132-1, M132-2, M132-3, M132-4, M132-5, M231-1, M231-2, M231-3, M231-4, M231-5.
}
\description{
Calculating the number of 44 motifs from a tripartite interaction network.
}
\details{
\strong{network.or.subnet_mat1}

There are two types of data that can be processed:
\itemize{
\item{Input in a network of type "igraph" alone.}

\item{Must be entered as data frame or matrix with \code{subnet_mat2}}}

About a network of type "igraph", It can be obtained from the connection matrices of subnetworks by the function \code{igraph_from_matrices}
}
\examples{

set.seed(12)
d <- build_net(11,22,21,0.2)
m <- motif_count(d)
m

set.seed(12)
d <- build_net(11,22,21,0.2,asmatrices=TRUE)

MAT<-d
M <- motif_count(MAT[[3]],MAT[[4]])
M

R<-rownames(MAT[[4]])[12]
MR<-MAT[[4]][12,]
MAT[[4]]<-MAT[[4]][-12,]
MAT[[4]]<-rbind(MAT[[4]],MR)
rownames(MAT[[4]])[22]<-R

motif_count(MAT[[3]],MAT[[4]])

}
\references{
Pilosof, S., Porter, M. A., Pascual, M., & Kéfi, S. (2017). The multilayer nature of ecological networks. Nature Ecology & Evolution, 1(4), 0101.

Simmons, B. I., Sweering, M. J., Schillinger, M., Dicks, L. V., Sutherland, W. J., & Di Clemente, R. (2019). bmotif: A package for motif analyses of bipartite networks. Methods in Ecology and Evolution, 10(5), 695-701.
}
