% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EffectivenessOfSolution.R
\name{EffectivenessOfSolution}
\alias{EffectivenessOfSolution}
\title{Function to estimate the effectiveness of solution sources (S.S.) by loss source (Percentage_I.I. > 0.00) in the production system.}
\usage{
EffectivenessOfSolution (DataLossSource,DataSolutionSource,ResultLossSource, verbose=TRUE)
}
\arguments{
\item{DataLossSource}{It is an matrix object containing data from loss sources.}

\item{DataSolutionSource}{It is an matrix object containing data from solution sources.}

\item{ResultLossSource}{Output of LossSource function.}

\item{verbose}{Logical value (TRUE/FALSE). TRUE displays the results of the effectiveness of solution}
}
\value{
The function returns several indices associated with the loss source.
}
\description{
This function allows to calculate E.S. of each S.S. by L.S. (significant in the reduction of defoliation or damage) in
the system. Equation: E.S. = R2 x (1 - P) when it is of the first degree, or E.S. = ((R2 x (1 - P))x(B2/B1) when
it is of the second degree. Where, R2 = determination coefficient and P = significance of ANOVA, B1 = regression coefficient,
and B2 = regression coefficient (variable2), of the simple regression equation of the S.S..
}
\examples{
data("DataLossSource")
ChisqTest_Distribution(DataLossSource)

data("DataSolutionSource")
ChisqTest_Distribution(DataSolutionSource)

data("DataDefoliation")
data("DataDamage")

DataResult=cbind(DataDefoliation,DataDamage$D.L.S.2,DataDefoliation,
DataDamage$D.L.S.4,DataDefoliation)
ResultLossSource=LossSource(DataLoss = DataLossSource,DataResult =DataResult,
Cols=c(1,3,5),verbose=TRUE)

EOS=EffectivenessOfSolution(DataLossSource =DataLossSource,
                            DataSolutionSource =DataSolutionSource,
                            ResultLossSource = ResultLossSource)
}
\seealso{
\code{\link{ReductionDamage}} ,  \code{\link{SolutionSource}}
}
\author{
Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)
}
