% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportToReport.R
\name{ExportToReport}
\alias{ExportToReport}
\title{Graphical and Statistic Report Generation}
\usage{
ExportToReport(
  obj,
  selection,
  write_to,
  overwrite = FALSE,
  onepage = TRUE,
  color_mode = c("white", "black")[1],
  add_key = "panel",
  precision = c("light", "full")[1],
  trunc_labels = 38,
  trans = asinh,
  bin,
  viewport = "ideas",
  display_progress = TRUE,
  ...
)
}
\arguments{
\item{obj}{an `IFC_data` object extracted with features extracted.}

\item{selection}{when provided, indices of desired graphs.
In such case onepage parameter is set to FALSE.
Note that indices are read from left to right, from top to bottom.}

\item{write_to}{pattern used to export file(s).
Placeholders, like c("\%d/\%s_fromR.pdf", "\%d/\%s_fromR.csv"), will be substituted:\cr
-\%d: with full path directory of 'obj$fileName'\cr
-\%p: with first parent directory of 'obj$fileName'\cr
-\%e: with extension of 'obj$fileName' (without leading .)\cr
-\%s: with shortname from 'obj$fileName' (i.e. basename without extension).\cr
Exported file(s) extension(s) will be deduced from this pattern. Note that has to be a .pdf and/or .csv.}

\item{overwrite}{whether to overwrite file or not. Default is FALSE.
Note that if TRUE, it will overwrite file. In addition a warning message will be sent.}

\item{onepage}{whether to generate a pdf with all graphs on one page or not. Default is TRUE.}

\item{color_mode}{Whether to extract colors from obj in white or black mode. Default is 'white'.}

\item{add_key}{whether to draw a 'global' key under title or in the first 'panel' or 'both'. Default is 'panel'.\cr
Accepted values are either: FALSE, 'panel', 'global', 'both' or c('panel', 'global').\cr
Note that it only applies when display is seen as overlaying populations.}

\item{precision}{when graphs is a 2D scatter with population overlay, this argument controls amount of information displayed. Default is "light".\cr
-"light", the default, will only display points of same coordinates that are amoung the other layers.\cr
-"full" will display all the layers.}

\item{trunc_labels}{maximum number of characters to display for labels. Default is 38.}

\item{trans}{transformation function for density graphs. Default is asinh.}

\item{bin}{default number of bin used for histogram. Default is missing.}

\item{viewport}{Either "ideas", "data" or "max" defining limits used for the graph. Default is "ideas".\cr
-"ideas" will use same limits as the one defined in ideas.\cr
-"data" will use data to define limits.\cr
-"max" will use data and regions drawn to define limits.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{...}{other parameters to be passed.}
}
\value{
It invisibly returns full path of exported .pdf and/or .csv file(s).
}
\description{
Generates report from `IFC_data` object.
}
\details{
depending on 'write_to', function will create .pdf and/or .csv file(s) report with according to graphs found in 'obj'.\cr
- csv file if created will contain "Min.","1st Qu.","Median","Mean","3rd Qu.","Max." for each graph found for x and y (if not histogram) for drawn populations and regions.\cr
- pdf file if created will contain graphs and to a certain extent some stats "Min.", "Median", "Mean", "Max." (no more than 7 rows).\cr
Note that only graphs will be exported (no images, features values, population stats, ...) in the same layout they were created and without sizing.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  tmp <- tempdir(check = TRUE)
  ## use a daf file
  file_daf <- system.file("extdata", "example.daf", package = "IFCdata")
  daf <- ExtractFromDAF(fileName = file_daf, extract_images = FALSE,
                        extract_offsets = FALSE, display_progress = FALSE)
  L = length(daf$graphs)
  if(L > 0) { 
    ## randomly export at most 5 graphs from daf
    sel = sample(1:L, min(5, L))
    ExportToReport(obj = daf, selection = sel,
                   write_to = paste0(tmp, "\\\\test.pdf"), overwrite = TRUE)
  }
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
