% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectidsa.R
\name{selectidsa}
\alias{selectidsa}
\title{Selecting optimal interaction for IDSA model.}
\usage{
selectidsa(formula, data, location, ndisc, methoddisc)
}
\arguments{
\item{formula}{A formula of spatial variables}

\item{data}{A data frame of dataset}

\item{location}{A character vector of location names in a data frame}

\item{ndisc}{A numeric vector of break numbers for respective
explanatory variables}

\item{methoddisc}{A character vector of discretization methods}
}
\value{
A list of process and results of optimal interaction for
IDSA model.
}
\description{
Selecting optimal interaction for IDSA model.
}
\examples{
sim$xd <- log(sim$xa * sim$xb)
s1 <- selectidsa(formula = y ~ xa + xb + xc + xd, data = sim,
                 location = c("lo", "la"),
                 ndisc = c(4,6,6,5), methoddisc = "quantile")

}
