% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d-gev.R
\name{qgev.d}
\alias{qgev.d}
\title{d-GEV quantile function}
\usage{
qgev.d(p, mut, sigma0, xi, theta, eta, d, tau = 0, eta2 = 0, ...)
}
\arguments{
\item{p}{vector of probabilities}

\item{mut, sigma0, xi}{numeric value, giving modified location, modified scale and shape parameter}

\item{theta}{numeric value, giving duration offset (defining curvature of the IDF curve for short durations)}

\item{eta}{numeric value, giving duration exponent (defining slope of the IDF curve)}

\item{d}{positive numeric value, giving duration}

\item{tau}{numeric value, giving intensity offset \eqn{\tau} (defining flattening of the IDF curve). Default: \eqn{\tau=0}.}

\item{eta2}{numeric value, giving a second duration exponent \eqn{\eta_{2}} (needed for multiscaling). Default: \eqn{\eta_2=0}.}

\item{...}{additional parameters passed to \code{\link[evd]{qgev}}}
}
\value{
list containing vectors of quantile values for given probabilities. 
The first element of the list are the q. values for the first given duration etc.
}
\description{
Quantile function of duration-dependent GEV distribution (inverse of the cumulative probability distribution function)
}
\details{
The duration dependent GEV distribution is defined after 
[Koutsoyiannis et al., 1998]:
\deqn{ G(x)= \exp[-\left( 1+\xi(x/\sigma(d)-\mu_t) \right)^{-1/\xi}] } 
with the duration dependent scale \eqn{\sigma(d)=\sigma_0/(d+\theta)^\eta} and 
modified location parameter \eqn{\mu_t=\mu/\sigma(d)}.

For details on the d-GEV and the parameter definitions, see \link{IDF-package}.
}
\examples{
p <- c(0.5,0.9,0.99)
# calulate quantiles for one duration
qgev.d(p=p,mut=4,sigma0=2,xi=0,theta=0.1,eta=0.3, d=1)

# calculate quantiles for sequence of durations
ds <- 2^seq(0,4,0.1)
qs <- lapply(ds,qgev.d,p=p,mut=4,sigma0=2,xi=0,theta=0.1,eta=0.3)
qs <- simplify2array(qs)

plot(ds,qs[1,],ylim=c(3,20),type='l',log = 'xy',ylab='Intensity',xlab = 'Duration')
for(i in 2:3){
  lines(ds,qs[i,],lty=i)
}
legend('topright',title = 'p-quantile',
       legend = p,lty=1:3,bty = 'n')
}
\seealso{
\code{\link{pgev.d}}, \code{\link{dgev.d}}, \code{\link{rgev.d}}
}
