% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{get_p}
\alias{get_p}
\title{Construct Optimisation Parameters.}
\usage{
get_p(gen_model, training_matrix, marker_mut_types, gene_lengths)
}
\arguments{
\item{gen_model}{(list)
A generative mutation model, fitted by fit_gen_model().}

\item{training_matrix}{(sparse matrix)
A sparse matrix of mutations in the training dataset, produced by get_mutation_tables().}

\item{marker_mut_types}{(character)
A character vector listing which mutation types (of the set specified in the generative model
attribute 'names') constitute the biomarker in question.}

\item{gene_lengths}{(dataframe)
A table with two columns: Hugo_Symbol and max_cds, providing the lengths of the genes to be modelled.}
}
\value{
A list with three entries:
\itemize{
\item A vector p, with an entry corresponding to each combination of gene and mutation type specified
in the generative model fitted. Each component is a non-negative value corresponding to a weighting
p to be supplied to a group lasso optimisation.
\item A numeric p_norm, giving the factor between p_{gs} and phi_{0gs} (see paper for details).
\item A vector biomarker_columns, detailing which of the elements of p correspond to gene/mutation type
combinations contributing to the biomarker in question.
}
}
\description{
An internal function. From the learned generative model and training data, produces a vector of weights p to be used in
the subsequent group lasso optimisation, alongside a biomarker-dependent normalisation quantity p_norm.
}
\examples{
p <- get_p(example_gen_model, example_tables$train$matrix,
           marker_mut_types = c("I"), gene_lengths = example_maf_data$gene_lengths)
print(p$p[1:5])
print(p$p_norm)
print(p$bc[1:5])
}
