% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-UserEfficiency.R
\name{meff}
\alias{meff}
\title{Calculates Relative Efficiency for Minimax Optimal Designs}
\usage{
meff(
  formula,
  predvars,
  parvars,
  family = gaussian(),
  lp,
  up,
  fimfunc = NULL,
  x2,
  w2,
  x1,
  w1,
  standardized = FALSE,
  localdes = NULL,
  crt.minimax.control = list(),
  npar = length(lp)
)
}
\arguments{
\item{formula}{A linear or nonlinear model \code{\link[stats]{formula}}.
A symbolic description of the model consists of predictors and the unknown model parameters.
Will be coerced to a \code{\link[stats]{formula}} if necessary.}

\item{predvars}{A vector of characters. Denotes the predictors in the \code{\link[stats]{formula}}.}

\item{parvars}{A vector of characters. Denotes the unknown parameters in the \code{\link[stats]{formula}}.}

\item{family}{A description of the response distribution and the link function to be used in the model.
This can be a family function, a call to a family function or a character string naming the family.
 Every family function has a link argument allowing to specify the link function to be applied on the response variable.
  If not specified, default links are used. For details see \code{\link[stats]{family}}.
   By default, a linear gaussian model \code{gaussian()} is applied.}

\item{lp}{Vector of lower bounds for the model parameters. Should be in the same order as \code{parvars} or \code{param} in the argument \code{fimfunc}.}

\item{up}{Vector of upper bounds for the model parameters. Should be in the same order as \code{parvars} or \code{param} in the argument \code{fimfunc}.
When a parameter is known (has a fixed value), its associated lower and upper bound values  in \code{lp} and \code{up}  must be set equal.}

\item{fimfunc}{A function. Returns the FIM as a \code{matrix}. Required when \code{formula} is missing. See 'Details' of \code{\link{minimax}}.}

\item{x2}{Vector of design (support) points of the optimal design (\eqn{\xi_2}). Similar to \code{x}.}

\item{w2}{Vector of corresponding design weights for \code{x2}.}

\item{x1}{Vector of design (support) points of \eqn{\xi_1}. See 'Details' of \code{\link{leff}}.}

\item{w1}{Vector of corresponding design weights for \code{x}.}

\item{standardized}{Maximin standardized design? When \code{standardized = TRUE}, the argument \code{localdes} must be given.
Defaults to \code{FALSE}. See 'Details' of \code{\link{minimax}}.}

\item{localdes}{A function that takes the parameter values  as inputs and returns the design points and weights of the locally optimal design.
Required when \code{standardized = "TRUE"}. See 'Details' of \code{\link{minimax}}.}

\item{crt.minimax.control}{Control parameters to optimize the minimax or standardized maximin criterion at a given design over a \strong{continuous} parameter space (when \code{n.grid = 0}).
For details, see the function \code{\link{crt.minimax.control}}.}

\item{npar}{Number of model parameters.  Used when \code{fimfunc} is given instead of \code{formula} to specify the number of model parameters.
If not specified truly, the sensitivity (derivative) plot may be shifted below the y-axis. When \code{NULL} (default), it is set to \code{length(lp)}.}
}
\value{
A value between 0 and 1.
}
\description{
Given a parameter space for the unknown parameters, this function calculates the D-efficiency of a design \eqn{\xi_1} with respect to a design \eqn{\xi_2}.
Usually, \eqn{\xi_2} is an  optimal design.
}
\details{
See Masoudi et al. (2017) for formula details.

The argument  \code{x1} is the vector of design points.
 For design points with more than one dimension (the models with more than one predictors),
   it is a concatenation of the design points, but \strong{dimension-wise}.
   For example, let the model has three predictors   \eqn{(I, S, Z)}.
    Then,  a two-point optimal design has the following points:
   \eqn{\{\mbox{point1} = (I_1, S_1, Z_1), \mbox{point2} = (I_2, S_2, Z_2)\}}{{point1 = (I1, S1, Z1), point2 = (I2, S2, Z2)}}.
    Then, the argument \code{x} is equal to
    \code{x = c(I1, I2, S1, S2, Z1, Z2)}.
}
\examples{
# Relative D-efficiency with respect to the minimax criterion
meff(formula = ~1/(1 + exp(-b * (x-a))), predvars = "x",
     parvars = c("a", "b"), family = "binomial",
     lp = c(-3, .5), up = c(3, 2),
     x2 = c(-3, -1.608782, 0, 1.608782, 3),
     w2 = c(0.22291601, 0.26438449, 0.02539899, 0.26438449, 0.22291601),
     x1 = c(-1, 1), w1 = c(.5, .5))



# A function to calculate the locally D-optimal design for the 2PL model
Dopt_2pl <- function(a, b){
  x <- c(a + (1/b) * 1.5434046, a - (1/b) * 1.5434046)
  return(list(x = x, w = c(.5, .5)))
}
# Relative D-efficiency with respect to the standardized maximin criterion
meff (formula = ~1/(1 + exp(-b * (x-a))), predvars = "x",
      parvars = c("a", "b"), family = "binomial",
      lp = c(-3, .5), up = c(3, 2),
      x2 = c(-3, -1.611255, 0, 1.611255, 3),
      w2 = c(0.22167034, 0.26592974, 0.02479984, 0.26592974, 0.22167034),
      x1 = c(0, -1), w1 = c(.5, .5),
      standardized = TRUE,
      localdes = Dopt_2pl)


}
