% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_related_functions.R
\name{VCFsToIDCatalogs}
\alias{VCFsToIDCatalogs}
\title{Create ID (small insertion and deletion) catalog from ID VCFs}
\usage{
VCFsToIDCatalogs(
  list.of.vcfs,
  ref.genome,
  region = "unknown",
  flag.mismatches = 0
)
}
\arguments{
\item{list.of.vcfs}{List of in-memory VCFs. The list names will be
the sample ids in the output catalog.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{region}{A character string acting as a region identifier, one of
"genome", "exome".}

\item{flag.mismatches}{Optional. If > 0, then if there are mismatches to
references in the ID (insertion/deletion) VCF, generate messages showing
the mismatched rows and continue. Otherwise \code{stop} if there are
mismatched rows. See \code{\link{AnnotateIDVCF}} for more details.}
}
\value{
A list of two elements. 1st element is an S3 object containing an ID
  (small insertion and deletion) catalog with class "IndelCatalog". See
  \code{\link{as.catalog}} for more details. 2nd element is a list of further
  annotated VCFs.
}
\description{
Create ID (small insertion and deletion) catalog from ID VCFs
}
\note{
In ID (small insertion and deletion) catalogs, deletion repeat sizes
  range from 0 to 5+, but for plotting and end-user documentation
  deletion repeat sizes range from 1 to 6+.
}
\examples{
file <- c(system.file("extdata/Strelka-ID-vcf/",
                      "Strelka.ID.GRCh37.s1.vcf",
                      package = "ICAMS"))
list.of.ID.vcfs <- ReadStrelkaIDVCFs(file)                      
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5",
 quietly = TRUE)) {
  catID <- VCFsToIDCatalogs(list.of.ID.vcfs, ref.genome = "hg19",
                            region = "genome")}
}
