% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{SplitOneMutectVCF}
\alias{SplitOneMutectVCF}
\title{Split a mutect2 VCF into SBS, DBS, and ID VCFs, plus a list of other mutations}
\usage{
SplitOneMutectVCF(vcf.df)
}
\arguments{
\item{vcf.df}{An in-memory data.frame representing a Mutect VCF, including
VAFs, which are added by \code{\link{ReadMutectVCF}}.}
}
\value{
A list with 3 in-memory VCFs and two left-over
VCF-like data frames with rows that were not incorporated
into the first 3 VCFs, as follows:

\enumerate{

 \item \code{SBS} VCF with only single base substitutions.

 \item \code{DBS} VCF with only doublet base substitutions
  as called by Mutect.

 \item \code{ID} VCF with only small insertions and deletions.

 \item \code{other.subs} VCF like data.frame with
 rows for coordinate substitutions involving
 3 or more nucleotides (e.g. ACT > TGA or AACT > GGTA)
 and rows for complex indels.

 \item \code{multiple.alt} VCF like data.frame with
 rows for variants with multiple alternative alleles, for example
 ACT mutated to both AGT and ACT at the same position.

}
}
\description{
Split a mutect2 VCF into SBS, DBS, and ID VCFs, plus a list of other mutations
}
\keyword{internal}
