% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotCatalogToPdf}
\alias{PlotCatalogToPdf}
\title{Plot catalog to a PDF file.}
\usage{
PlotCatalogToPdf(catalog, file, plot.SBS12 = NULL, cex = NULL,
  grid = NULL, upper = NULL, xlabels = NULL)
}
\arguments{
\item{catalog}{A catalog as defined in \code{\link{ICAMS}} with attributes added.
See \code{\link{as.catalog}} for more details.}

\item{file}{The name of the PDF file to be produced.}

\item{plot.SBS12}{Only meaningful for class \code{SBS192Catalog}; if \code{TRUE},
generate an abbreviated plot of only SBS without context, i.e. 
C>A, C>G, C>T, T>A, T>C, T>G each on transcribed and untranscribed strands,
rather than SBS in trinucleotide context, e.g.
ACA > AAA, ACA > AGA, ..., TCT > TAT, ... There are 12 bars in the graph.}

\item{cex}{A numerical value giving the amount by which mutation class labels,
mutation counts(if it exists), y axis and its labels, x axis labels and
its annotations(if it exists), sample name and legend(if it exists)
should be magnified relative to the default. Only implemented for SBS96Catalog,
SBS192Catalog and DBS144Catalog.}

\item{grid}{A logical value indicating whether to draw grid lines. Only
implemented for SBS96Catalog.}

\item{upper}{A logical value indicating whether to draw horizontal lines and
the names of major mutation class on top of graph. Only implemented for
SBS96Catalog.}

\item{xlabels}{A logical value indicating whether to draw x axis labels. Only
implemented for SBS96Catalog.}
}
\value{
\code{invisible(TRUE)}
}
\description{
Plot catalog to a PDF file. The type of graph is based on one
attribute("catalog.type") of the input catalog. You can first use
\code{\link{TransformCatalog}} to get different types of catalog and then do
the plotting.
}
\note{
The sizes of repeats involved in deletions range from 0 to 5+ in the
  mutational-spectra and signature catalog rownames, but for plotting and
  end-user documentation deletion repeat sizes range from 1 to 6+.
}
\examples{
file <- system.file("extdata",
                    "strelka.regress.cat.sbs.96.csv",
                    package = "ICAMS")
catSBS96 <- ReadCatalog(file)
colnames(catSBS96) <- "sample"
PlotCatalogToPdf(catSBS96, file = file.path(tempdir(), "test.pdf"))
}
