% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_catalog.R
\name{WriteCatalog}
\alias{WriteCatalog}
\title{Write a catalog}
\usage{
WriteCatalog(catalog, file, strict = TRUE)
}
\arguments{
\item{catalog}{A catalog as defined in \code{\link{ICAMS}};
see also \code{\link{as.catalog}}.}

\item{file}{The path to the file to be created.}

\item{strict}{If TRUE, do additional checks on the input, and stop if the
checks fail.}
}
\description{
Write a catalog to a file.
}
\details{
See also \code{\link{ReadCatalog}}.
}
\note{
In ID (insertion and deletion) catalogs, deletion repeat sizes
  range from 0 to 5+, but for plotting and end-user documentation
  deletion repeat sizes range from 1 to 6+.
}
\examples{
file <- system.file("extdata",
                    "strelka.regress.cat.sbs.96.csv",
                    package = "ICAMS")
catSBS96 <- ReadCatalog(file, ref.genome = "hg19", 
                        region = "genome",
                        catalog.type = "counts")
WriteCatalog(catSBS96, file = file.path(tempdir(), "catSBS96.csv"))
}
