% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foopTTable.R
\name{hpTcteTab}
\alias{hpTcteTab}
\title{Table of Enthalpies, Function of Pressure for Fixed Temperature}
\usage{
hpTcteTab(p1, p2, dp, Temp)
}
\arguments{
\item{p1}{first pressure value [ MPa ]}

\item{p2}{final pressure [ MPa ]}

\item{dp}{Pressure increment [ MPa ]}

\item{Temp}{Temperature [ K ]}
}
\value{
A table of Enthalpies for fixed T and a p Interval: p1:p2.
}
\description{
The function \code{hpTcteTab(p1, p2, dp, Temp)} returns a table of 
    Enthalpies [kJ kg-1] for a fixed Temp [K] within a range of p [MPa]: p1:p2 [MPa]
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
p1 <- 1.0
p2 <- 10.
dp <- 1.
Temp <- 500.
Tabh <- hpTcteTab(p1, p2, dp, Temp)
Tabh

p1 <- 10.
p2 <- 100.
dp <- 10.
Temp <- 450.
Tabh <- hpTcteTab(p1, p2, dp, Temp)
Tabh

}
