% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiGammaBeta.R
\name{mvbeta}
\alias{mvbeta}
\alias{lmvbeta}
\title{Multivariate Beta function (of complex variable)}
\usage{
lmvbeta(a, b, p)

mvbeta(a, b, p)
}
\arguments{
\item{a, b}{real or complex numbers with \code{Re(a)>0} and \code{Re(b)>0}}

\item{p}{a positive integer, the dimension}
}
\value{
A real or a complex number.
}
\description{
The multivariate Beta function (\code{mvbeta}) and
  its logarithm (\code{lmvbeta}).
}
\examples{
a <- 5; b <- 4; p <- 3
mvbeta(a, b, p)
mvgamma(a, p) * mvgamma(b, p) / mvgamma(a+b, p)
}
