% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorFormula.R
\name{factorFormula}
\alias{factorFormula}
\title{Convert Factor Levels in Formula to Numeric Values}
\usage{
factorFormula(form, network)
}
\arguments{
\item{form}{A formula object.}

\item{network}{A \code{HydeNetwork} object.}
}
\description{
When working in R, it is often more convenient to work in
  terms of the factor labels rather than the underlying numeric values.
  JAGS, however, requires that the numeric values be used.  
  \code{factorFormula} permits the user to define formulae to be passed
  to JAGS using R style coding, and having factor levels translated 
  to the underlying values as determined by the network structure.
}
\details{
It is assumed that factor variables will be used in logical
  comparisons of the format \code{[variable_name] == '[factor_level]'} and
  only this pattern is recognized in the text search.  Single or 
  double quotes may be used around the level, and the spaces aroudn the
  \code{==} are optional.  
  
  While there are certainly limitations to this function that we have
  not yet found, we believe it covers the majority of cases in which
  it is useful. More complex cases that can't be handled by 
  \code{factorFormula} may require writing native JAGS code.
}
\examples{
\dontrun{
Net <- HydeNetwork(~ wells +
                    pe | wells +
                    d.dimer | pregnant*pe +
                    angio | pe +
                    treat | d.dimer*angio +
                    death | pe*treat,
                  data = PE)
factorFormula(form = payoff ~ (death == 'No') + (pe == 'Yes'),
              network = Net)
}

}
\author{
Jarrod Dalton and Benjamin Nutter
}

