% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/HydePosterior.R
\name{HydePosterior}
\alias{HydePosterior}
\title{Posterior Distributions of a Decision Network}
\usage{
HydePosterior(cHN, variable.names, n.iter, thin = 1, ...,
  monitor_observed = TRUE, bind = TRUE)
}
\arguments{
\item{cHN}{A \code{compiledHydeNetwork} object as returned by
\code{compileJagsNetwork}.}

\item{variable.names}{a character vector giving the names of variables to be monitored.}

\item{n.iter}{number of iterations to monitor.}

\item{thin}{thinning interval for monitors.}

\item{...}{options arguments that are passed to the update method for
jags model objects.}

\item{monitor_observed}{If TRUE, the observed or fixed variables (those
passed to the \code{data} argument in \code{compileJagsNetwork}) are
forced into \code{variable.names} if not already provided.  This is
recommended, especially if you will be binding multiple JAGS runs
together.}

\item{bind}{Logical. If \code{TRUE}, posterior distributions will be bound into
  a single data frame.  If \code{FALSE}, the standard output from \code{rjags}
  is returned.}
}
\value{
A list of class \code{HydePosterior} with elements \code{codas}
  (the MCMC matrices from \code{coda.samples}), \code{observed} (the values
  of the variables that were observed), \code{dag} (the dag object for
  convenience in displaying the network), and \code{factorRef} (giving the
  mappings of factor levels to factor variables).

  The only rationale for giving this object its own class was because it
  produces an enormous amount of material to be printed.  A distinct
  \code{print} method has been written for this object.
}
\description{
The posterior distributions of the decision network can be
  evaluated to determine the probabilistic outcomes based on the decision
  inputs in the model as well as subject specific factors.
}
\details{
This is essentially a wrapper around \code{coda.samples} that
  returns in a list the output for each run of \code{coda.samples} over
  the rows of the policy/decision matrix given in the \code{data} argument
  of \code{compileJagsNetwork}.
}
\examples{
data(PE, package="HydeNet")
Net <- HydeNetwork(~ wells +
                     pe | wells +
                     d.dimer | pregnant*pe +
                     angio | pe +
                     treat | d.dimer*angio +
                     death | pe*treat,
                     data = PE)


compiledNet <- compileJagsModel(Net, n.chains=5)

#* Generate the posterior distribution
Posterior <- HydePosterior(compiledNet,
                           variable.names = c("d.dimer", "death"),
                           n.iter = 1000)

#* Posterior Distributions for a Decision Model
Net <- setDecisionNodes(Net, angio, treat)
decisionNet <- compileDecisionModel(Net, n.chains=5)
decisionsPost <- HydePosterior(decisionNet,
                               variable.names = c("d.dimer", "death"),
                               n.iter = 1000)
}
\author{
Jarrod Dalton and Benjamin Nutter
}

