% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeVariancePartitioning.R
\name{computeVariancePartitioning}
\alias{computeVariancePartitioning}
\title{computeVariancePartitioning}
\usage{
computeVariancePartitioning(hM, group = NULL, groupnames = NULL,
  start = 1, na.ignore = FALSE)
}
\arguments{
\item{hM}{a fitted \code{Hmsc} model object}

\item{group}{vector of numeric values corresponding to group identifiers in groupnames}

\item{groupnames}{vector of names for each group of fixed effect}

\item{start}{index of first MCMC sample included}

\item{na.ignore}{logical. If TRUE, covariates are ignored for sites where the focal species
is NA when computing variance-covariance matrices for each species}
}
\value{
returns an object VP with components VP$vals, VP$R2T, VP$group and VP$groupnames.
}
\description{
Computes variance components with respect to given grouping of fixed effects and levels
of random effects
}
\details{
The vector \code{group} has one value for each column of the matrix \code{hM$X}, describing the index of the
group in which this column is to be included. The names of the group are given by \code{groupnames}. The output object
\code{VP$vals} gives the variance proportion for each group and species. The output object \code{VP$R2T} gives the
variance among species explained by traits, measured for species' responses to covariates (\code{VP$R2T$Beta}) and species occurrences
(\code{VP$R2T$Y})
}
\examples{
# Partition the explained variance for a previously fitted model
# without grouping environmental covariates
VP = computeVariancePartitioning(TD$m)

# Partition the explained variance for a previously fitted model
# while grouping the two environmental variables together
VP = computeVariancePartitioning(TD$m, group=c(1,1), groupnames = c("Habitat"))

}
