% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hlab.r
\name{hlab}
\alias{hlab}
\title{hlab}
\usage{
hlab(x, name = NULL, html = FALSE, plotmath = TRUE)
}
\arguments{
\item{x}{a single variable name, unquoted}

\item{name}{a single character string providing an alternate way to name \code{x} that is useful when \code{hlab} is called from another function such as \code{hlabs}}

\item{html}{set to \code{TRUE} to return HTML strings instead of \code{plotmath} expressions}

\item{plotmath}{set to \code{FALSE} to use plain text instead of plotmath}
}
\value{
an expression created by \code{labelPlotmath} with \code{plotmath=TRUE}
}
\description{
Easy Extraction of Labels/Units Expressions for Plotting
}
\details{
Given a single unquoted variable, first looks to see if a non-\code{NULL} \code{LabelsUnits} object exists (produced by \code{extractlabs()}).  When \code{LabelsUnits} does not exist or is \code{NULL}, looks up the attributes in the current dataset, which defaults to \code{d} or may be specified by \code{options(current_ds='name of the data frame/table')}.  Finally the existence of a variable of the given name in the global environment is checked. When a variable is not found in any of these three sources or has a blank \code{label} and \code{units}, an \code{expression()} with the variable name alone is returned.  If \code{html=TRUE}, HTML strings are constructed instead, suitable for \code{plotly} graphics.

The result is useful for \code{xlab} and \code{ylab} in base plotting functions or in \code{ggplot2}, along with being useful for \code{labs} in \code{ggplot2}.  See example.
}
\examples{
d <- data.frame(x=1:10, y=(1:10)/10)
d <- upData(d, labels=c(x='X', y='Y'), units=c(x='mmHg'), print=FALSE)
hlab(x)
hlab(x, html=TRUE)
hlab(z)
require(ggplot2)
ggplot(d, aes(x, y)) + geom_point() + labs(x=hlab(x), y=hlab(y))
# Can use xlab(hlab(x)) + ylab(hlab(y)) also
# Store names, labels, units for all variables in d in object
LabelsUnits <- extractlabs(d)
# Remove d; labels/units still found
rm(d)
hlab(x)
# Remove LabelsUnits and use a current dataset named
# d2 instead of the default d
rm(LabelsUnits)
options(current_ds='d2')
}
\seealso{
\code{\link[=label]{label()}}, \code{\link[=units]{units()}}, \code{\link[=contents]{contents()}}, \code{\link[=hlabs]{hlabs()}}, \code{\link[=extractlabs]{extractlabs()}}, \link{plotmath}
}
\author{
Frank Harrell
}
