% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hashCheck.r
\name{runifChanged}
\alias{runifChanged}
\title{runifChanged}
\usage{
runifChanged(fun, ..., file = NULL, .print. = TRUE, .inclfun. = TRUE)
}
\arguments{
\item{fun}{the (usually slow) function to run}

\item{...}{input objects the result of running the function is dependent on}

\item{file}{file in which to store the result of \code{fun} augmented by attributes containing hash digests}

\item{.print.}{set to \code{TRUE} to list which objects changed that neessitated re-running \code{f}}

\item{.inclfun.}{set to \code{FALSE} to not include \code{fun} in the hash digest, i.e., to not require re-running \code{fun} if only \code{fun} itself has changed}
}
\value{
the result of running \code{fun}
}
\description{
Re-run Code if an Input Changed
}
\details{
Uses \code{hashCheck} to run a function and save the results if specified inputs have changed, otherwise to retrieve results from a file.  This makes it easy to see if any objects changed that require re-running a long simulation, and reports on any changes.  The file name is taken as the chunk name appended with \code{.rds} unless it is given as \verb{file=}.  \code{fun} has no arguments.  Set \code{.inclfun.=FALSE} to not include \code{fun} in the hash check (for legacy uses).  The typical workflow is as follows.\preformatted{f <- function(       ) \{
# . . . do the real work with multiple function calls ...
\}
seed <- 3
set.seed(seed)
w <- runifChanged(f, seed, obj1, obj2, ....)
}

\verb{seed, obj1, obj2}, ... are all the objects that \code{f()} uses that if changed
would give a different result of \code{f()}.  This can include functions such as
those in a package, and \code{f} will be re-run if any of the function's code
changes.  \code{f} is also re-run if the code inside \code{f} changes.
The result of \code{f} is stored with \code{saveRDS} by default in file named \code{xxx.rds}
where \code{xxx} is the label for the current chunk.  To control this use instead
\code{file=xxx.rds} add the file argument to \code{runifChanged(...)}.  If nothing has
changed and the file already exists, the file is read to create the result
object (e.g., \code{w} above).  If \code{f()} needs to be run, the hashed input objects
are stored as attributes for the result then the enhanced result is written to the file.

See \href{https://hbiostat.org/rflow/caching.html}{here} for examples.
}
\author{
Frank Harrell
}
