% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simMarkovOrd.r
\name{soprobMarkovOrd}
\alias{soprobMarkovOrd}
\title{soprobMarkovOrd}
\usage{
soprobMarkovOrd(y, times, initial, absorb = NULL, intercepts, g, ...)
}
\arguments{
\item{y}{a vector of possible y values in order (numeric, character, factor)}

\item{times}{vector of measurement times}

\item{initial}{initial value of \code{y} (baseline state; numeric, character, factr)}

\item{absorb}{vector of absorbing states, a subset of \code{y}.  The default is no absorbing states. (numeric, character, factor)}

\item{intercepts}{vector of intercepts in the proportional odds model, with length one less than the length of \code{y}}

\item{g}{a user-specified function of three or more arguments which in order are \code{yprev} - the value of \code{y} at the previous time, the current time \code{t}, the \code{gap} between the previous time and the current time, an optional (usually named) covariate vector \code{X}, and optional arguments such as a regression coefficient value to simulate from.  The function needs to allow \code{yprev} to be a vector and \code{yprev} must not include any absorbing states.  The \code{g} function returns the linear predictor for the proportional odds model aside from \code{intercepts}.  The returned value must be a matrix with row names taken from \code{yprev}.  If the model is a proportional odds model, the returned value must be one column.  If it is a partial proportional odds model, the value must have one column for each distinct value of the response variable Y after the first one, with the levels of Y used as optional column names.  So columns correspond to \code{intercepts}. The different columns are used for \code{y}-specific contributions to the linear predictor (aside from \code{intercepts}) for a partial or constrained partial proportional odds model.  Parameters for partial proportional odds effects may be included in the ... arguments.}

\item{...}{additional arguments to pass to \code{g} such as covariate settings}
}
\value{
matrix with rows corresponding to times and columns corresponding to states, with values equal to exact state occupancy probabilities
}
\description{
State Occupancy Probabilities for First-Order Markov Ordinal Model
}
\seealso{
\url{https://hbiostat.org/R/Hmisc/markov/}
}
\author{
Frank Harrell
}
