% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawHiveSpline.R
\name{drawHiveSpline}
\alias{drawHiveSpline}
\title{Draw a 3D Spline as Part of a 3D Hive Plot}
\usage{
drawHiveSpline(HPD, L_A = FALSE, ...)
}
\arguments{
\item{HPD}{An object of S3 class \code{HivePlotData}.}

\item{L_A}{Logical: should splines be drawn with \code{line_antialias =
TRUE}?}

\item{\dots}{Parameters to be passed downstream.}
}
\value{
None.  A spline is added to the 3D hive plot in progress.
}
\description{
This function analyzes the edges of a \code{HivePlotData} object in order to
draw 3D splines representing those edges.  Each pair of nodes at the ends of
an edge is identified, and a control point is computed.  This information is
passed to \code{\link{rcsr}} to work out the details.
}
\seealso{
\code{\link{plot3dHive}} which calls this function and is the user
interface.
}
\author{
Bryan A. Hanson, DePauw University. \email{hanson@depauw.edu}
}
\keyword{hplot}
\keyword{plot}
