% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_MatH.R
\docType{methods}
\name{WH.bind}
\alias{WH.bind}
\alias{WH.bind,MatH,MatH-method}
\alias{WH.bind,MatH-method}
\title{Method WH.bind}
\usage{
WH.bind(object1, object2, byrow)

\S4method{WH.bind}{MatH,MatH}(object1, object2, byrow = TRUE)
}
\arguments{
\item{object1}{a \code{MatH} object}

\item{object2}{a \code{MatH} object}

\item{byrow}{a logical value (default=TRUE) attaches the objects by row}
}
\value{
a \code{MatH} object,
}
\description{
Method WH.bind

It attaches two \code{MatH} objects with the same columns by row, or the same rows by colum.
}
\examples{
# binding by row 
M1<-BLOOD[1:10,1]
M2<-BLOOD[1:10,3]
MAT<-WH.bind(M1,M2, byrow=TRUE)
# binding by col
M1<-BLOOD[1:10,1]
M2<-BLOOD[1:10,3]
MAT<-WH.bind(M1,M2, byrow=FALSE)
}
\seealso{
\code{\link{WH.bind.row}} for binding by row, \code{\link{WH.bind.col}} for binding by column
}

