% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newmap.scale.R
\name{newmap.scale}
\alias{newmap.scale}
\title{Add Scale to Existing Unprojected Map}
\usage{
newmap.scale(x, y, relwidth = 0.15, metric = TRUE, ratio = TRUE,
  col.line = "black", ...)
}
\arguments{
\item{x}{Location of left end of distance gauge.}

\item{y}{Location of left end of distance gauge.}

\item{relwidth}{Proportion of width of display to be used for the scale. The default is 0.15.}

\item{metric}{If TRUE, the distance gauge will be in km, otherwise miles.}

\item{ratio}{If FALSE, the scale ratio of the map is not displayed.}

\item{col.line}{The color of lines for the gauge.}

\item{...}{Further plotting parameters may be specified as for the command text().}
}
\value{
The exact calculated scale is returned.
}
\description{
Adds a scale to an existing map, both as a ratio and a distance gauge.
If x or y are not specified, this will be taken to be near the lower left corner of the map.
}
\details{
newmap.scale Add Scale to Existing Unprojected Map
}
\examples{
\dontrun{
library("maps")
library("HelpersMG")
map("world", "China")
newmap.scale(col.line = "red", col="blue")
}
}
\author{
See map.scale {maps}
}

