% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.haplinStrat.R
\name{plot.haplinStrat}
\alias{plot.haplinStrat}
\title{Plotter function for haplinStrat results.}
\usage{
\method{plot}{haplinStrat}(x, filename, title, windows,
  plot.signif.only = FALSE, signif.thresh = 0.05, y.lim, x.title,
  y.title, file.width, file.height, ...)
}
\arguments{
\item{x}{The \code{\link{haplinSlide}} object (NB: only the output produced by
running \code{\link{haplinSlide}} with the \code{table.output} argument set to TRUE!)}

\item{filename}{If the plot should be saved to the disk, give the name of the output
file including the file extension.}

\item{title}{If the user wishes to override the default title of the plot, give it here.}

\item{windows}{Numerical vector. If given, this will only plot the chosen windows.}

\item{plot.signif.only}{Logical: whether to filter out the "non-significant" markers
from the plot. Default: FALSE, i.e., plot everything.}

\item{signif.thresh}{The threshold defining the significant p-values: if
\code{plot.signif.only == TRUE}, then only the markers with relative risk p-values
lower than the threshold will be kept for plotting. Default: 0.05.}

\item{y.lim}{Vector with two numbers setting the Y limits of the plotted graph.}

\item{x.title}{Title for the X axis (default: "marker").}

\item{y.title}{Title for the Y axis (default: "RR (log scale)").}

\item{file.width}{Width (in inches) for the output plot, if a filename was given.}

\item{file.height}{Height (in inches) for the output plot, if a filename was given.}

\item{...}{other arguments (ignored).}
}
\value{
\code{\link[ggplot2]{ggplot}} object.
}
\description{
This will automatically plot all haplinStrat results on one figure.
}
\details{
This function uses the same style as \code{\link{plot.haplinSlide}} and plots all of
 the \code{\link{haplinStrat}} results on one figure, for easy comparison. NB: those 
  estimates that have infinite confidence interval will not be plotted.
}
