% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HadIBDs.R
\name{Hadamard_to_IBDs}
\alias{Hadamard_to_IBDs}
\title{Incomplete Block Designs using Hadamard Matrix (HadIBDs)}
\usage{
Hadamard_to_IBDs(v)
}
\arguments{
\item{v}{is expressed as product of (4t_i-1), where t_i = 2^x,(i=1,2,...) and (x = 0,1,2...)}
}
\value{
This function generates an IBD based on modified Hadamard matrices or their Kronecker product along with the Parameters, Information matrix, Average variance factor and Canonical efficiency factor of the generated design.
}
\description{
Incomplete Block Designs using Hadamard Matrix (HadIBDs)
}
\examples{
library(HadIBDs)
Hadamard_to_IBDs(9)
}
\references{
1) R.C. Bose, K.R. Nair (1939). Partially balanced incomplete block designs, Sankhya 4, 337-372. https://www.jstor.org/stable/40383923.

2) M.N. VARTAK (1955). On an application of Kronecker product of matrices to statistical
designs,The Annals of Mathematical Statistics 26, 420-438.
}
