% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_kinetics.R
\name{plot_kinetics}
\alias{plot_kinetics}
\title{Plot kinetics data}
\usage{
plot_kinetics(kin_dat, theoretical = FALSE, relative = TRUE)
}
\arguments{
\item{kin_dat}{calculated kinetic data by \code{\link{calculate_kinetics}} 
function}

\item{theoretical}{\code{logical}, determines if plot shows theoretical values}

\item{relative}{\code{logical}, determines if values are relative or absolute}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plots kinetics of the hydrogen-deuterium exchange for specific peptides.
}
\details{
This function visualises the output of the  
\code{\link{calculate_kinetics}} function. 
Based on supplied parameters appropriate columns are chosen for the plot. 
The uncertainty associated with each peptide is shown as a ribbon. 
Axis are labeled according to the supplied parameters but no title is provided.

If you want to plot data for more then one peptide in one state, join 
calculated data by using \code{\link{bind_rows}} from dplyr package and 
pass the result as kin_dat.
}
\examples{
# load example data
dat <- read_hdx(system.file(package = "HaDeX", "HaDeX/data/KD_180110_CD160_HVEM.csv"))

# calculate data for the sequence INITSSASQEGTRLN in the CD160 state 
(kin1 <- calculate_kinetics(dat, 
                           protein = "db_CD160",
                           sequence = "INITSSASQEGTRLN", 
                           state = "CD160",
                           start = 1, 
                           end = 15,
                           time_in = 0.001, 
                           time_out = 1440))

# calculate data for the sequence INITSSASQEGTRLN in the CD160_HVEM state 
(kin2 <- calculate_kinetics(dat, 
                           protein = "db_CD160",
                           sequence = "INITSSASQEGTRLN", 
                           state = "CD160_HVEM",
                           start = 1, 
                           end = 15,
                           time_in = 0.001, 
                           time_out = 1440)) 
                         
# load extra packages 
library(dplyr)
  
# plot a single peptide - theoretical and relative
plot_kinetics(kin_dat = kin1, 
              theoretical = TRUE, 
              relative = TRUE)
                
# plot joined data - experimental and absolute
bind_rows(kin1, kin2) \%>\%
  plot_kinetics(theoretical = FALSE, 
                relative = FALSE)
                
}
\seealso{
\code{\link{calculate_kinetics}}
}
