% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_coverage.R
\name{plot_coverage}
\alias{plot_coverage}
\title{Plot peptide coverage}
\usage{
plot_coverage(
  dat,
  protein = dat[["Protein"]][1],
  chosen_state = dat[["State"]][1]
)
}
\arguments{
\item{dat}{data as imported by the \code{\link{read_hdx}} function}

\item{protein}{protein to be included in plot}

\item{chosen_state}{sequence states to be included in plot}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plots the peptide coverage of the protein sequence.
}
\details{
The function \code{plot_coverage} plots sequence coverage based on experimental data for chosen protein in chosen state. 
Only non-duplicated peptides are shown on the plot, next to each other. 

The aim of this plot is to see the dependence between positions of the peptides on the protein sequence. Their position in y-axis 
does not contain any information.
}
\examples{
# load example data
dat <- read_hdx(system.file(package = "HaDeX", 
                            "HaDeX/data/KD_180110_CD160_HVEM.csv"))
                            
# plot coverage with default parameters
plot_coverage(dat)

# plot coverage with explicit parameters
plot_coverage(dat, protein = "db_CD160", chosen_state = "CD160_HVEM")

}
\seealso{
\code{\link{read_hdx}} \code{\link{plot_position_frequency}}
}
