% Generated by roxygen2 (4.0.1): do not edit by hand
\name{xcount}
\alias{xcount}
\title{Find Exact Number of Genotype Tables}
\usage{
xcount(m, safety = 1e+10, safeSecs = 10)
}
\arguments{
\item{m}{vector containing the numbers of alleles of each type. Length must be at least 2 and all must be non-negative integers. It can also be a \code{matrix} of genotype counts.}

\item{safety}{Stop execution if the approximate table number obtained from \code{\link{acount}} is more than this cutoff.}

\item{safeSecs}{Time limit in seconds. Another safety feature to prevent getting stuck in a too-long computation}
}
\value{
The exact number of tables
}
\description{
Use \code{xcount} to determine the exact number of tables (i.e., genotype numbers) for a given set of allele counts. This method enumerates all tables, and is best when the total number is less than 10^10 or so. This function is mostly called by \code{\link{hwx.test}} rather than directly by the user. If the number of tables is too large to enumerate with this method, use \code{\link{acount}} for an approximation.
}
\examples{
# Allele counts from human Rh locus. Guo and Thompson, 1992, Figure 1
#
alleles <- c(15, 14, 11, 12, 2, 2, 1, 3)
xcount(alleles)
}
\references{
The methods are described by \href{http://dx.doi.org/10.1534/genetics.109.108977}{Engels, 2009. \bold{Genetics} 183:1431}.
}
\seealso{
\code{\link{hwx.test}}, \code{\link{acount}}
}

