% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconcileTransitionProbability.R
\name{reconcileTransitionProbability}
\alias{reconcileTransitionProbability}
\title{Reconciliation of Transition Probability}
\usage{
reconcileTransitionProbability(
  df,
  hmap_type = NULL,
  cellid_column,
  time_column
)
}
\arguments{
\item{df}{Data frame. The input data frame should contain two columns, cell ID from scoreHVT function and timestamp of that dataset.}

\item{hmap_type}{Character. ('self_state', 'without_self_state', or 'All')}

\item{cellid_column}{Character. Name of the column containing cell IDs.}

\item{time_column}{Character. Name of the column containing timestamps}
}
\value{
A list of plotly heatmap objects and tables representing the transition probability heatmaps.
}
\description{
This is the main function for creating reconciliation plots and tables which 
helps in comparing the transition probabilities calculated manually and from markovchain function
}
\examples{
dataset <- data.frame(date = as.numeric(time(EuStockMarkets)),
                      DAX = EuStockMarkets[, "DAX"],
                      SMI = EuStockMarkets[, "SMI"],
                      CAC = EuStockMarkets[, "CAC"],
                      FTSE = EuStockMarkets[, "FTSE"])

hvt.results<- trainHVT(dataset,n_cells = 60, depth = 1, quant.err = 0.1,
                       distance_metric = "L1_Norm", error_metric = "max",
                       normalize = TRUE,quant_method = "kmeans")
scoring <- scoreHVT(dataset, hvt.results)
cell_id <- scoring$scoredPredictedData$Cell.ID
time_stamp <- dataset$date
dataset <- data.frame(cell_id, time_stamp)

reconcileTransitionProbability(dataset, hmap_type = "All", 
cellid_column = "cell_id", time_column = "time_stamp")
}
\seealso{
\code{\link{trainHVT}} \cr \code{\link{scoreHVT}}
}
\author{
PonAnuReka Seenivasan <ponanureka.s@mu-sigma.com>, Vishwavani <vishwavani@mu-sigma.com>
}
\keyword{Diagnostics_or_Validation}
