% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edaPlots.R
\name{edaPlots}
\alias{edaPlots}
\title{plots for data analysis}
\usage{
edaPlots(df, time_series = FALSE, time_column)
}
\arguments{
\item{df}{Dataframe. A data frame object.}

\item{time_series}{Logical. A value to indicate whether the dataset is time_series or not.}

\item{time_column}{Character. The name of the time column in the data frame.}
}
\value{
Five objects which include time series plots, data distribution plots, 
box plots, correlation plot and a descriptive statistics table.
}
\description{
This is the main function that provides exploratory data analysis plots
}
\examples{
dataset <- data.frame(date = as.numeric(time(EuStockMarkets)),
                      DAX = EuStockMarkets[, "DAX"],
                      SMI = EuStockMarkets[, "SMI"],
                      CAC = EuStockMarkets[, "CAC"],
                      FTSE = EuStockMarkets[, "FTSE"])
edaPlots(dataset, time_series = TRUE, time_column = 'date')
}
\author{
Vishwavani <vishwavani@mu-sigma.com>
}
\keyword{EDA}
