#' (Data) A simulated HTS-SIP dataset
#'
#' 6 gradients:
#' \itemize{
#'   \item{*}{12C-control, replicate 1}
#'   \item{*}{12C-control, replicate 2}
#'   \item{*}{12C-control, replicate 3}
#'   \item{*}{13C-treatment, replicate 1}
#'   \item{*}{13C-treatment, replicate 2}
#'   \item{*}{13C-treatment, replicate 3}
#'   }
#'
#' @name data-physeq_rep3
#' @aliases physeq_rep3
#' @docType data
#' @keywords data
NA

#' (Data) qPCR data associated with the physeq_rep3 HTS-SIP dataset
#'
#' The dataset contains simulated 16S rRNA copies for each gradient
#' fraction of each gradient (measured via qPCR).
#'
#' @name data-physeq_rep3_qPCR
#' @aliases physeq_rep3_qPCR
#' @docType data
#' @keywords data
#' @seealso
#' \code{physeq_rep3}
NA


#' (Data) A subset of full HTS-SIP dataset (Substrates=2, Days=1)
#'
#' 1 of the 2 'substrates' is the 12C-control;
#' the other is the 13C-labeled substrate
#'
#' @name data-physeq_S2D1
#' @aliases physeq_S2D1
#' @docType data
#' @keywords data
NA

#' (Data) A subset of full HTS-SIP dataset (Substrates=2, Days=1)
#'
#' 1 of the 2 'substrates' is the 12C-control;
#' the other is the 13C-labeled substrate.
#'
#' The dataset has been parsed into a list of corresponding
#' 13C-treatment vs 12C-control comparisons. Each comparison
#' is of all gradient fraction samples of the treatment vs
#' the gradient fraction samples of the control.
#'
#' @name data-physeq_S2D1_l
#' @aliases physeq_S2D1_l
#' @docType data
#' @keywords data
NA

#' (Data) A subset of full HTS-SIP dataset (Substrates=2, Days=2)
#'
#' 1 of the 2 'substrates' is the 12C-control;
#' the other is the 13C-labeled substrate.
#'
#' @name data-physeq_S2D2
#' @aliases physeq_S2D2
#' @docType data
#' @keywords data
NA

#' (Data) A subset of full HTS-SIP dataset (Substrates=2, Days=2)
#'
#' 1 of the 2 'substrates' is the 12C-control;
#' the other is the 13C-labeled substrate.
#'
#' The dataset has been parsed into a list of corresponding
#' 13C-treatment vs 12C-control comparisons. Each comparison
#' is of all gradient fraction samples of the treatment vs
#' the gradient fraction samples of the control.
#'
#' @name data-physeq_S2D2_l
#' @aliases physeq_S2D2_l
#' @docType data
#' @keywords data
NA
