% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HRSIP.R
\name{HRSIP}
\alias{HRSIP}
\title{(MW-)HR-SIP analysis}
\usage{
HRSIP(physeq, design, density_windows = data.frame(density_min = c(1.7),
  density_max = c(1.75)), sparsity_threshold = seq(0, 0.3, 0.1),
  sparsity_apply = "all", l2fc_threshold = 0.25, padj_method = "BH",
  padj_cutoff = NULL, parallel = FALSE)
}
\arguments{
\item{physeq}{Phyloseq object}

\item{design}{\code{design} parameter used for DESeq2 analysis.
This is usually used to differentiate labeled-treatment and unlabeld-control samples.
See \code{DESeq2::DESeq} for more details on the option.}

\item{density_windows}{The buoyant density window(s) used for for calculating log2
fold change values. Input can be a vector (length 2) or a data.frame with a 'density_min'
and a 'density_max' column (each row designates a density window).}

\item{sparsity_threshold}{All OTUs observed in less than this portion (fraction: 0-1)
of gradient fraction samples are pruned. This is a form of indepedent filtering.
The sparsity cutoff with the most rejected hypotheses is used.}

\item{sparsity_apply}{Apply sparsity threshold to all gradient fraction samples ('all')
or just 'heavy' fraction samples ('heavy'), where 'heavy' samples are designated
by the \code{density_windows}.}

\item{l2fc_threshold}{log2 fold change (l2fc) values must be significantly above this
threshold in order to reject the hypothesis of equal counts.
See \code{DESeq2} for more information.}

\item{padj_method}{Method for global p-value adjustment (See \code{p.adjust()}).}

\item{padj_cutoff}{Adjusted p-value cutoff for rejecting the null hypothesis
that l2fc values were not greater than the l2fc_threshold.
Set to \code{NULL} to skip filtering of results to the sparsity cutoff with most
rejected hypotheses and filtering each OTU to the buoyant density window with the
greatest log2 fold change.}

\item{parallel}{Process each parameter combination in parallel.
See \code{plyr::mdply()} for more information.}
}
\value{
dataframe of HRSIP results
}
\description{
Conduct (multi-window) high resolution stable isotope probing (HR-SIP) analysis.
}
\details{
The (MW-)HR-SIP workflow is as follows:

\enumerate{
  \item For each sparsity threshold & BD window: calculate log2 fold change values (with DESeq2) for each OTU
  \item Globally adjust p-values with a user-defined method (see p.adjust())
  \item Select the sparsity cutoff with the most rejected hypotheses
  \item For each OTU, select the BD window with the greatest log2 fold change value
}
}
\examples{
data(physeq_S2D2_l)

\dontrun{
# HR-SIP on just 1 treatment-control comparison
## 1st item in list of phyloseq objects
physeq = physeq_S2D2_l[[1]]
## HR-SIP
### Note: treatment-control samples differentiated with 'design=~Substrate'
df_l2fc = HRSIP(physeq, design=~Substrate)
head(df_l2fc)

## Same, but multiple BD windows (MW-HR-SIP) & run in parallel
### Windows = 1.7-1.73 & 1.72-1.75
doParallel::registerDoParallel(2)
dw = data.frame(density_min=c(1.7, 1.72), density_max=c(1.73, 1.75))
df_l2fc = HRSIP(physeq_S2D1_l[[1]],
                design=~Substrate,
                density_windows=dw,
                parallel=TRUE)
head(df_l2fc)
}

}
