% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Repeated.R
\name{hrm.test.2}
\alias{hrm.test.2}
\title{Test for main effects and interaction effects of one or two between-subject factors and one or two within-subject factors}
\usage{
hrm.test.2(X, alpha = 0.05, group, subgroup, factor1, factor2, subject, data)
}
\arguments{
\item{X}{A data.frame containing the data}

\item{alpha}{alpha level used for the test}

\item{group}{column name within the data frame data specifying the groups}

\item{subgroup}{column name within the data frame data specifying the subgroups (crossed with groups)}

\item{factor1}{column name within the data frame data specifying the first subplot-factor}

\item{factor2}{column name within the data frame data specifying the the second subplot-factor (crossed with factor1)}

\item{subject}{column name within the data frame X identifying the subjects}

\item{data}{column name within the data frame X containing the response variable}
}
\value{
Returns a data frame consisting of the degrees of freedom, the test value, the critical value and the p-value
}
\description{
Test for main effects and interaction effects of one or two between-subject factors and one or two within-subject factors
}
\examples{
n=c(45, 22, 57, 36)
X_1 = mvrnorm(n = n[1], mu = rep(0,40), Sigma = diag(40))
X_2 = mvrnorm(n = n[2], mu = rep(0,40), Sigma = diag(40))
X_3 = mvrnorm(n = n[3], mu = rep(0,40), Sigma = diag(40))
X_4 = mvrnorm(n = n[4], mu = rep(0,40), Sigma = diag(40))

X_1 = c(t(as.matrix(X_1)))
X_1 = data.frame(group = "SCC+", value = X_1)

X_2 = c(t(as.matrix(X_2)))
X_2 = data.frame(group= "SCC-", value = X_2)


X_3 = c(t(as.matrix(X_3)))
X_3 = data.frame(group = "MCI", value = X_3)


X_4 = c(t(as.matrix(X_4)))
X_4 = data.frame(group = "AD", value = X_4)

X = rbind(X_1, X_2, X_3, X_4)
X$subject = gl(160, 40)
X$variable = as.factor(rep(gl(4, 10),160))
X$region = as.factor(rep(rep(1:10,4),160))
X$subgroup = as.factor(rep(gl(2, 40),80))
X$group = as.factor(X$group)

hrm.test.dataframe(data=X,alpha=0.05,group="group",factor1="variable",
factor2="region",subject="subject",response="value")
}
\keyword{internal}

