% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstHMMCop.R
\name{EstHMMCop}
\alias{EstHMMCop}
\title{Estimation of bivariate Markov regime switching bivariate copula model}
\usage{
EstHMMCop(y, reg, family, max_iter, eps)
}
\arguments{
\item{y}{(nx2) data matrix (observations or residuals) that will be transformed to pseudo-observations}

\item{reg}{number of regimes}

\item{family}{'gaussian' , 't' , 'clayton' , 'frank' , 'gumbel'}

\item{max_iter}{maximum number of iterations of the EM algorithm}

\item{eps}{precision (stopping criteria); suggestion 0.0001.}
}
\value{
\item{theta}{(1 x reg) estimated parameter of the copula according to CRAN copula package (except for Frank copula, where theta = log(theta_R_Package)) for each regime (except for degrees of freedom)}

\item{dof}{estimated degree of freedom, only for the Student copula}

\item{Q}{(reg x reg) estimated transition matrix}

\item{eta}{(n x reg) conditional probabilities of being in regime k at time t given observations up to time t}

\item{tau}{estimated Kendall tau for each regime}

\item{U}{(n x 2) matrix of Rosenblatt transforms}

\item{cvm}{Cramer-von-Mises statistic for goodness-of-fit}

\item{W}{regime probabilities for the conditional distribution given the past Kendall's tau}
}
\description{
This function estimates parameters from a bivariate Markov regime switching bivariate copula model
}
\examples{
Q <- matrix(c(0.8, 0.2, 0.3, 0.7),2,2) ; kendallTau <- c(0.3 ,0.7) ;
data <- SimHMMCop(Q, 'clayton', kendallTau, 10)$SimData;
estimations <- EstHMMCop(data,2,'clayton',10000,0.0001)


}
