% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HFDutils.R
\name{HFDparse}
\alias{HFDparse}
\title{internal function for modifying freshly read HFD data in its standard form}
\usage{
HFDparse(DF, item = NULL)
}
\arguments{
\item{DF}{a data.frame of HFD data, freshly read in.}

\item{item}{character string of the data product code, which is the base file name, but excluding the country code and file extension \code{.txt}. For instance, \code{"mabRR"} or \code{"tfrVHbo"}. This will be passed in, potentially, by the reader.}
}
\value{
DF same data.frame, modified so that columns are of a useful class. If there were open age categories, such as \code{"-"} or \code{"+"}, this information is stored in a new dummy column called \code{OpenInterval}.
}
\description{
called by \code{readHFD()} and \code{readHFDweb()}. We assume there are no factors in the given data.frame and that it has been read in from the raw text files using something like: \code{ read.table(file = filepath, header = TRUE, skip = 2, na.strings = ".", as.is = TRUE)}. This function is visible to users, but is not likely needed directly.
}
\details{
This parse routine is based on the subjective opinions of the author...
}
