% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_functions.R
\name{resid_conditional.default}
\alias{resid_conditional.default}
\alias{resid_conditional.lmerMod}
\alias{resid_conditional}
\alias{resid_conditional.lme}
\title{Conditional residuals}
\usage{
\method{resid_conditional}{default}(object, type)

\method{resid_conditional}{lmerMod}(
  object,
  type = c("raw", "pearson", "studentized", "cholesky")
)

\method{resid_conditional}{lme}(
  object,
  type = c("raw", "pearson", "studentized", "cholesky")
)
}
\arguments{
\item{object}{an object of class \code{lmerMod} or \code{lme}.}

\item{type}{a character string specifying what type of residuals should be calculated.
It is set to \code{"raw"} (observed - fitted) by default. Other options include
\code{"pearson"}, \code{"studentized"}, and \code{"cholesky"}. 
Partial matching of arguments is used, so only the first character needs to be provided.}
}
\value{
A vector of conditional residuals.
}
\description{
Calculates conditional residuals of \code{lmerMod} and \code{lme} model objects.
}
\details{
For a model of the form \eqn{Y = X \beta + Z b + \epsilon},
four types of marginal residuals can be calculated:

\describe{
  \item{\code{raw}}{\eqn{e = Y - X \hat{beta} - Z \hat{b}}}
  \item{\code{pearson}}{\eqn{e / \sqrt{diag(\hat{Var}(Y|b)})}}
  \item{\code{studentized}}{\eqn{e / \sqrt{diag(\hat{Var}(e))}}}
  \item{\code{cholesky}}{\eqn{\hat{C}^{-1} e} where \eqn{\hat{C}\hat{C}^\prime = \hat{Var}(e)}}
}
}
\references{
Singer, J. M., Rocha, F. M. M., & Nobre, J. S. (2017). 
Graphical Tools for Detecting Departures from Linear Mixed Model 
Assumptions and Some Remedial Measures. 
\emph{International Statistical Review}, \bold{85}, 290--324.

Schabenberger, O. (2004) Mixed Model Influence Diagnostics,
in \emph{Proceedings of the Twenty-Ninth SAS Users Group International Conference},
SAS Users Group International.
}
