% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UNItoGLS.R
\name{UNItoGLS}
\alias{UNItoGLS}
\title{Translate UNIFORMAT to GL String}
\usage{
UNItoGLS(uniformat, prefix = "HLA-", pre = TRUE)
}
\arguments{
\item{uniformat}{A character string of HLA allele names and operators in the UNIFORMAT format signifying their relation with one another.}

\item{prefix}{A character string of the desired gene-system prefix (default is "HLA-").}

\item{pre}{A logical that indicates whether returned allele names should contain 'prefix' (TRUE), or if 'prefix' should be excluded from returned names (FALSE).}
}
\value{
An version of 'uniformat' converted to GL String format, or FALSE if 'uniformat' is invalid.
}
\description{
A wrapper function for UNtoGL() which translates strings from UNIFORMAT format to GL String format.
}
\note{
This function does not return the "?" operator, as the "?" operator has no cognate in UNIFORMAT.
}
\examples{
UNItoGLS("A*02:01,A*03:01|A*02:01,A*03:02|A*02:02,A*03:01|A*02:02,A*03:02")
UNItoGLS("A,B|A,C~D G|E W,X|W,Y Z,J J,Z")

}
\references{
Nunes Tissue Antigens 2007;69(s1):203-205 https://doi.org/10.1111/j.1399-0039.2006.00808.x

Mack et al. HLA 2023;102(2):206-212 https://doi.org/10.1111/tan.15126
}
