% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlTable.R
\name{htmlTable}
\alias{htmlTable}
\title{htmlTable}
\usage{
htmlTable(
  tab,
  vars = NULL,
  lines = NULL,
  cex = 1,
  title = "",
  rowsum = NULL,
  colsum = NULL,
  fmt = "\%.0f",
  total = NULL,
  ...
)
}
\arguments{
\item{tab}{two dimensional table object}

\item{vars}{character: names of row and column variable}

\item{lines}{character: final line (default: \code{NULL})}

\item{cex}{numeric: font size (default: \code{1})}

\item{title}{character: table title  (default: \code{''})}

\item{rowsum}{character: add row sums at the right (default: \code{NULL})}

\item{colsum}{character: add column sums at the bottom (default: \code{NULL})}

\item{fmt}{character: format string for \code{sprintf} (default: \code{"\%.0f"})}

\item{total}{character: add the grand total at the bottom left (default: \code{NULL})}

\item{...}{further parameters given to \code{html_matrix}}
}
\value{
html_matrix object
}
\description{
Creates a HTML table from a two dimensional table object.
}
\examples{
htab <- htmlTable(apply(Titanic,1:2,sum), c("Sex", "Class"), title="Titanic")
toHTML(htab, browser=interactive())
}
